
/* ############################################################################################## */
/* ---------------------------------------------------------------------------------------------- */
/*                                                                                                */
/*                              Hier sind die Websockets eingebunden                              */
/*                                                                                                */
/* ---------------------------------------------------------------------------------------------- */
/* ############################################################################################## */


let socket = new WebSocket(`ws://${window.location.hostname}/ws`);

//  Funktionen die genutzt werden können
//  Nachricht an den Server senden:     socket.send("connection:success"); 

socket.onopen = function (e) {
    console.log("Websockets Verbindung hergstellt!");
};

socket.onmessage = function (event) {
    
    console.log('Nachricht vom Server erhalten:', event.data);

    if ( event.data == "1" ) {
        document.getElementById("state").innerText = "ON";
    }

    if ( event.data == "0" ) {
        document.getElementById("state").innerText = "OFF";
    }

};


socket.onclose = function (event) {
    if (event.wasClean) {
        console.log('Verbindung zum Server wurde geschlossen!');
    } else {
        console.log('Verbindung verloren: Timeout!');
    }
};


socket.onerror = function (error) {
    console.log('[error]:', error.message);
};