/*

  ESP8266 HomeKit Kontaktsensor
  CC by cooper @ makesmart.net
  Mehr Informationen zu ESP8266 D1 Mini & Co.:
  https://makesmart.net

  Library used: https://github.com/Mixiaoxiao/Arduino-HomeKit-ESP8266

*/

#include <Arduino.h>
#include <arduino_homekit_server.h>
#include "wifi_info.h"

#define LOG_D(fmt, ...)   printf_P(PSTR(fmt "\n") , ##__VA_ARGS__);

//  https://makesmart.net/esp8266-d1-mini-datenblatt/
// Zuerst Pins mit einem Pullup verwenden, ansonsten einen Pullup einbauen!
// GPIO0 D3; GPIO2 = D4;
byte inputPin = 0; // GPIO0 = D3


bool lastNotifiedState = false;

void setup() {
  Serial.begin(115200);
  wifi_connect();
  //homekit_storage_reset();
  my_homekit_setup();

  pinMode(inputPin, INPUT);
  
}

void loop() {
  my_homekit_loop();
  delay(10);
}

//==============================
// HomeKit setup and loop
//==============================

// Zugriff auf die Definitionen des Accessories in my_accessory.c
extern "C" homekit_server_config_t config;
extern "C" homekit_characteristic_t cha_contact_sensor_state;

static uint32_t next_heap_millis = 0;

void my_homekit_setup() {
  arduino_homekit_setup(&config);
}


void update_motion(){
  // bool switch_is_on = true/false;
  // cha_switch_on.value.bool_value = switch_is_on;
  // homekit_characteristic_notify(&cha_switch_on, cha_switch_on.value);

  if(lastNotifiedState != digitalRead(inputPin)){
    Serial.println("SENSOR-STATE CHANGED!");
    cha_contact_sensor_state.value.bool_value = digitalRead(inputPin);
    homekit_characteristic_notify(&cha_contact_sensor_state, cha_contact_sensor_state.value);
    lastNotifiedState = digitalRead(inputPin);
  }
  
}


void my_homekit_loop() {
  arduino_homekit_loop();
  const uint32_t t = millis();
  if (t > next_heap_millis) {
    // heap-Info alle 30 Sekunden im seriellen Monitor ausgeben
    next_heap_millis = t + 30 * 1000;
    LOG_D("Free heap: %d, HomeKit clients: %d",
        ESP.getFreeHeap(), arduino_homekit_connected_clients_count());
  }

  update_motion();
  
}
